#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

class ModArr
{
public:
    vector<int> arr;
    ModArr(vector<int> init)
    {
        for(int x : init)
            arr.push_back(x);
    }

    int operator[](int n)
    {
        return arr[n%arr.size()];
    }

    void PostElement(int n, int val)
    {
        arr[n] = val;
    }
};

bool SviJednaki(ModArr& a, int n)
{
    for(int i = 0; i < n-1; ++i)
        if(a[i] != a[i+1]) return false;

    return true;
}

void Faktorizacija(vector<int>& result, int n)
{
    result.push_back(1);
    result.push_back(n);
    if(n % 2 == 0)
    {
        result.push_back(2);
        result.push_back(n/2);
    }
    for(int i = 3; i*i <= n; i+=2)
    {
        if(n % i == 0)
        {
            result.push_back(i);
            result.push_back(n/i);
        }
    }

}

bool DaLiJePeriod(ModArr& a, int d, int p)
{
    for(int i = p; i < p+d; ++i)
        if(a[i] != a[i+d]) return false;

    return true;
}

bool MogucPeriod(ModArr& a, int n, int d)
{
    for(int i = 0; i < n; ++i)
        if(!DaLiJePeriod(a, d, i)) return false;
    return true;
}


int MinPeriod(ModArr& a, int n, vector<int>& faktori)
{
    for(int i : faktori)
        if(MogucPeriod(a, n, i)) return i;

}

void UpdateB(ModArr& a, ModArr& b, int i)
{
    int res1 = a[i-1] ^ a[i];
    int res2 = a[i] ^ a[i+1];
    b.PostElement(i-1,res1);
    b.PostElement(i,res2);
}

bool IsPrime(int n)
{
    if(n == 1) return false;
    if(n == 3 || n == 2) return true;
    if(n % 2 == 0) return false;

    for(int i = 3; i*i <= n; ++i)
        if(n % i == 0) return false;
    return true;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);


    int n, q;
    cin >> n >> q;

    vector<int> arr (n);
    for(int i = 0; i < n; ++i)
    {
        cin >> arr[i];
    }

    ModArr arra(arr);
    vector<int> b (n);
    for(int i = 0; i < n-1; ++i)
        b[i] = arr[i] ^ arr[i+1];
    b[n-1] = arr[n-1] ^ arr[0];

    ModArr arrb(b);

    if(!IsPrime(n))
    {
        return 0;
    }
        if(SviJednaki(arrb, n))
            cout << 1 <<"\n";
        else
            cout << n << "\n";

    int p, v;
    for(int i = 0; i < q; ++i)
    {
        cin >> p>> v;
        --p;
        arra.PostElement(p, v);
        UpdateB(arra, arrb, p);
        if(SviJednaki(arrb, n))
            cout << 1 <<"\n";
        else
            cout << n <<"\n";


    }

}